import 'package:flutter/material.dart';
import 'package:flutter_animate/flutter_animate.dart';
import 'package:flutter_widget_from_html/flutter_widget_from_html.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/my_images.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/style.dart';
import 'package:viserpay/data/model/reward/reward_response_model.dart';

class ClaimBottomSheet extends StatelessWidget {
  final Reward reward;
  final void Function() onTap;
  const ClaimBottomSheet({super.key, required this.reward, required this.onTap});

  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      padding: EdgeInsets.symmetric(horizontal: Dimensions.space10, vertical: 5),
      decoration: BoxDecoration(borderRadius: BorderRadius.circular(Dimensions.largeRadius), color: MyColor.colorWhite),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Align(
            alignment: Alignment.topRight,
            child: GestureDetector(onTap: () => Get.back(), child: Icon(Icons.close)),
          ),
          SizedBox(height: Dimensions.space10),
          Text(
            MyStrings.doYouWantToClaimThisReward.tr,
            style: regularDefault.copyWith(fontSize: 22),
            textAlign: TextAlign.center,
          ),
          SizedBox(height: Dimensions.space20),
          Container(
            padding: EdgeInsets.all(15),
            decoration: BoxDecoration(
              color: MyColor.primaryColor,
              shape: BoxShape.circle,
            ),
            child: Image.asset(MyImages.reward, height: 30, width: 30, color: MyColor.colorWhite).animate(onComplete: (controller) => controller.repeat()).moveY(duration: 1000.ms, begin: 1.8, end: 0.0),
          ),
          SizedBox(height: Dimensions.space15),
          Text(
            MyStrings.confirmReward.tr,
            style: lightDefault.copyWith(),
            textAlign: TextAlign.center,
          ),
          SizedBox(height: Dimensions.space15),
          Padding(
            padding: const EdgeInsets.symmetric(horizontal: 30.0),
            child: Text(
              MyStrings.rewardOffer.replaceAll("_", reward.validityDays ?? ""),
              style: lightDefault.copyWith(color: MyColor.redCancelTextColor),
              textAlign: TextAlign.center,
            ),
          ),
          SizedBox(height: Dimensions.space25),
          Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              GestureDetector(
                onTap: () => Get.back(),
                child: Container(
                  padding: EdgeInsets.symmetric(horizontal: 30, vertical: 8),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(20),
                    //  border: Border.all(color: MyColor.primaryColor),
                    color: MyColor.colorBlack,
                  ),
                  child: Text(MyStrings.no.tr, style: regularDefault.copyWith(color: MyColor.colorWhite)),
                ),
              ),
              SizedBox(width: Dimensions.space20),
              GestureDetector(
                onTap: onTap,
                child: Container(
                  padding: EdgeInsets.symmetric(horizontal: 30, vertical: 8),
                  decoration: BoxDecoration(borderRadius: BorderRadius.circular(20), color: MyColor.primaryColor),
                  child: Text(
                    MyStrings.yes.tr,
                    style: regularDefault.copyWith(color: MyColor.colorWhite),
                  ),
                ),
              ),
            ],
          ),
          SizedBox(height: Dimensions.space15),
        ],
      ),
    );
  }
}
